#  ----------------------------------------------------------------------------
#          ATMEL Microcontroller Software Support  -  ROUSSET  -
#  ----------------------------------------------------------------------------
#  Copyright (c) 2006, Atmel Corporation
#
#  All rights reserved.
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions are met:
#
#  - Redistributions of source code must retain the above copyright notice,
#  this list of conditions and the disclaiimer below.
#
#  - Redistributions in binary form must reproduce the above copyright notice,
#  this list of conditions and the disclaimer below in the documentation and/or
#  other materials provided with the distribution. 
#
#  Atmel's name may not be used to endorse or promote products derived from
#  this software without specific prior written permission. 
#
#  DISCLAIMER: THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR
#  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
#  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
#  DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,
#  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
#  OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
#  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#  ----------------------------------------------------------------------------


if { [ catch { source "$libPath(extLib)/$target(board)/SRAM.tcl"} errMsg] } {
    messageDialg  error.gif "SRAM Memory Description File not found:\n$errMsg" "File not found" ok
    exit
}

if { [ catch { source "$libPath(extLib)/$target(board)/SDRAM.tcl"} errMsg] } {
    messageDialg  error.gif "SDRAM Memory Description File not found:\n$errMsg" "File not found" ok
    exit
}


array set memoryAlgo {
    "SRAM"                    "::at91sam9260_sram"
    "SRAM2"                   "::at91sam9260_sram2"
    "SDRAM"                   "::at91sam9260_sdram"
    "Peripheral"              "::at91sam9260_peripheral"
    "ROM"                     "::at91sam9260_rom"
    "REMAP"                   "::at91sam9260_remap"
}

array set at91sam9260_sram {
    dftDisplay  1
    dftDefault  0
    dftAddress  0x200000
    dftSize     0x1000
    dftSend     "SRAM::sendFile"
    dftReceive  "SRAM::receiveFile"
    dftScripts  ""
}

array set at91sam9260_sram2 {
    dftDisplay  1
    dftDefault  0
    dftAddress  0x300000
    dftSize     0x1000
    dftSend     "SRAM::sendFile"
    dftReceive  "SRAM::receiveFile"
    dftScripts  ""
}

array set at91sam9260_sdram {
    dftDisplay  1
    dftDefault  1
    dftAddress  0x20000000
    dftSize     0x800000
    dftSend     "SDRAM::sendFile"
    dftReceive  "SDRAM::receiveFile"
    dftScripts  "::at91sam9260_sdram_scripts"
}

array set at91sam9260_sdram_scripts {
    "Enable SDRAM"                   "SDRAM::initSDRAM"
    "Set SDRAM to <already up>"      "SDRAM::initSDRAM_already_up"
}

array set at91sam9260_peripheral {
    dftDisplay  0
    dftDefault  0
    dftAddress  0xF0000000
    dftSize     0x10000000
    dftSend     ""
    dftReceive  ""
    dftScripts  ""
}

array set at91sam9260_rom {
    dftDisplay  0
    dftDefault  0
    dftAddress  0x400000
    dftSize     0x8000
    dftSend     ""
    dftReceive  ""
    dftScripts  ""
}

array set at91sam9260_remap {
    dftDisplay  0
    dftDefault  0
    dftAddress  0x00000000
    dftSize     0x8000
    dftSend     ""
    dftReceive  ""
    dftScripts  ""
}


################################################################################
#  proc reset
################################################################################
proc reset {} {
    
    global AT91C_RSTC_RCR AT91C_RSTC_RMR
    global AT91C_RSTC_PROCRST AT91C_RSTC_PERRST AT91C_RSTC_EXTRST

    global target
    set dummy_err 0

    puts "-I- Reset the board"

    TCL_Write_Int $target(handle) [expr [expr 0xA5 << 24] | [expr 8 << 8]] $AT91C_RSTC_RMR dummy_err
    TCL_Write_Int $target(handle) [expr [expr 0xA5 << 24] | $AT91C_RSTC_PROCRST | $AT91C_RSTC_PERRST | $AT91C_RSTC_EXTRST] $AT91C_RSTC_RCR dummy_err
}
